/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartDraw;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCFillStyle;
import jclass.chart.MinMax;

class AreaChartDraw
extends ChartDraw {
    Polygon[][] polyList;
    static final int XINSIDE = 1;
    static final int XBYX1 = 2;
    static final int XBYX2 = 3;
    static final int YINSIDE = 10;
    static final int YBYTOP = 11;
    static final int YBYORIGIN = 12;
    Point prev;
    Point next;
    Point last;
    Rectangle r;

    public AreaChartDraw(ChartDataView chartDataView) {
        super(chartDataView);
    }

    public void recalc() {
        super.recalc();
        ChartDataViewSeries[] chartDataViewSeriesArray = this.dataObject.getSeries();
        boolean bl = this.dataObject.xaxis.isVertical;
        this.polyList = new Polygon[chartDataViewSeriesArray.length][];
        int n = 0;
        while (n < chartDataViewSeriesArray.length) {
            ChartDataViewSeries chartDataViewSeries = chartDataViewSeriesArray[n];
            this.polyList[n] = null;
            if (chartDataViewSeries.maxXIndex() != 0 && chartDataViewSeries.maxYIndex() != 0) {
                double d = 0.0;
                double d2 = this.dataObject.holeValue;
                boolean bl2 = false;
                this.polyList[n] = new Polygon[Math.min(chartDataViewSeries.maxXIndex(), chartDataViewSeries.maxYIndex())];
                int n2 = 0;
                this.polyList[n][n2] = new Polygon();
                int n3 = 0;
                while (n3 < this.polyList[n].length) {
                    double d3;
                    double d4 = chartDataViewSeries.getX(n3);
                    bl2 = this.clipAreaPolygon(d, d2, d4, d3 = chartDataViewSeries.getY(n3), this.polyList[n][n2], bl2, bl);
                    if (!bl2 && this.polyList[n][n2].npoints > 0) {
                        this.finishAreaPolygon(this.polyList[n][n2], bl);
                        this.polyList[n][++n2] = new Polygon();
                    }
                    d = d4;
                    d2 = d3;
                    ++n3;
                }
                if (this.polyList[n][n2].npoints > 0) {
                    this.finishAreaPolygon(this.polyList[n][n2], bl);
                } else {
                    this.polyList[n][n2] = null;
                }
            }
            ++n;
        }
    }

    public void draw(Graphics graphics) {
        ChartDataViewSeries[] chartDataViewSeriesArray = this.dataObject.getSeries();
        if (this.polyList == null) {
            return;
        }
        int n = 0;
        while (n < this.polyList.length) {
            if (this.polyList[n] != null) {
                JCChartStyle jCChartStyle;
                ChartDataViewSeries chartDataViewSeries = chartDataViewSeriesArray[n];
                if (chartDataViewSeries.isShowing && (jCChartStyle = chartDataViewSeries.getStyle()) != null) {
                    JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
                    int n2 = 0;
                    while (n2 < this.polyList[n].length) {
                        if (this.polyList[n][n2] != null) {
                            jCFillStyle.fillOutlinePolygon(graphics, this.polyList[n][n2], this.chartArea.getForeground());
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    private boolean clipAreaPolygon(double d, double d2, double d3, double d4, Polygon polygon, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = 0;
        if (!bl) {
            if (d == this.dataObject.holeValue || d2 == this.dataObject.holeValue) {
                n2 = 1;
                n = 1;
            } else {
                n = JCChartUtil.locateX(d, this.dataObject.xaxis.min.value, this.dataObject.xaxis.max.value);
            }
        }
        if (n2 == 0) {
            if (d3 == this.dataObject.holeValue || d4 == this.dataObject.holeValue) {
                n2 = 1;
                n = 1;
            } else {
                n2 = JCChartUtil.locateX(d3, this.dataObject.xaxis.min.value, this.dataObject.xaxis.max.value);
                if (bl && n2 != 0) {
                    n = JCChartUtil.locateX(d, this.dataObject.xaxis.min.value, this.dataObject.xaxis.max.value);
                }
            }
        }
        if (n != 0 && n2 != 0 && n == n2) {
            return false;
        }
        if (bl) {
            if (bl2) {
                polygon.addPoint(this.dataObject.yaxis.toPixel(d4), this.dataObject.xaxis.toPixel(d3));
            } else {
                polygon.addPoint(this.dataObject.xaxis.toPixel(d3), this.dataObject.yaxis.toPixel(d4));
            }
        } else if (bl2) {
            polygon.addPoint(this.dataObject.yaxis.toPixel(this.dataObject.yaxis.origin.value), this.dataObject.xaxis.toPixel(d));
            polygon.addPoint(this.dataObject.yaxis.toPixel(d2), this.dataObject.xaxis.toPixel(d));
            polygon.addPoint(this.dataObject.yaxis.toPixel(d4), this.dataObject.xaxis.toPixel(d3));
        } else {
            polygon.addPoint(this.dataObject.xaxis.toPixel(d), this.dataObject.yaxis.toPixel(this.dataObject.yaxis.origin.value));
            polygon.addPoint(this.dataObject.xaxis.toPixel(d), this.dataObject.yaxis.toPixel(d2));
            polygon.addPoint(this.dataObject.xaxis.toPixel(d3), this.dataObject.yaxis.toPixel(d4));
        }
        return true;
    }

    private void finishAreaPolygon(Polygon polygon, boolean bl) {
        if (bl) {
            polygon.addPoint(this.dataObject.yaxis.toPixel(this.dataObject.yaxis.origin.value), polygon.ypoints[polygon.npoints - 1]);
        } else {
            polygon.addPoint(polygon.xpoints[polygon.npoints - 1], this.dataObject.yaxis.toPixel(this.dataObject.yaxis.origin.value));
        }
        polygon.addPoint(polygon.xpoints[0], polygon.ypoints[0]);
    }

    JCDataIndex pick(Point point, int n) {
        double d;
        double d2;
        double d3;
        double d4;
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        int n2 = -1;
        int n3 = -1;
        JCDataIndex jCDataIndex = null;
        ChartDataViewSeries[] chartDataViewSeriesArray = this.dataObject.getSeries();
        boolean bl = this.dataObject.xaxis.isVertical;
        MinMax minMax = new MinMax();
        MinMax minMax2 = new MinMax();
        this.dataObject.getDataBounds(minMax, minMax2);
        int n4 = this.dataObject.yaxis.toPixel(this.dataObject.yaxis.origin.value);
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        long l = 0L;
        int n8 = 0;
        int n9 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n10 = 0;
        int n11 = 0;
        long l2 = rectangle.width + rectangle.height;
        int n12 = chartDataViewSeriesArray.length - 1;
        while (n12 >= 0 && l2 > 0L) {
            if (chartDataViewSeriesArray[n12].isShowing) {
                n7 = n12;
                Point point3 = this.dataObject.getFirstLast();
                d4 = chartDataViewSeriesArray[n12].getX(point3.x);
                d3 = chartDataViewSeriesArray[n12].getY(point3.x);
                bl2 = d4 == this.dataObject.holeValue || d3 == this.dataObject.holeValue;
                n10 = bl2 ? 1 : JCChartUtil.locateXY(d4, d3, minMax.min, minMax.max, minMax2.min, minMax2.max);
                boolean bl4 = false;
                int n13 = point3.x + 1;
                while (n13 <= point3.y && l2 > 0L) {
                    boolean bl5;
                    d2 = chartDataViewSeriesArray[n12].getX(n13);
                    d = chartDataViewSeriesArray[n12].getY(n13);
                    bl3 = d2 == this.dataObject.holeValue || d == this.dataObject.holeValue;
                    n11 = bl3 ? 2 : JCChartUtil.locateXY(d2, d, minMax.min, minMax.max, minMax2.min, minMax2.max);
                    boolean bl6 = bl5 = bl2 || bl3;
                    if (!(n10 != 0 && n11 != 0 || bl5)) {
                        long l3;
                        double d9;
                        long l4;
                        if (bl) {
                            if (!bl4) {
                                d6 = this.dataObject.xaxis.toPixel(d4);
                                d5 = this.dataObject.yaxis.toPixel(d3);
                            }
                            d8 = this.dataObject.xaxis.toPixel(d2);
                            d7 = this.dataObject.yaxis.toPixel(d);
                            l = d7 < (double)n4 && d5 > (double)n4 || d5 < (double)n4 && d7 > (double)n4 ? ((l4 = JCChartUtil.distTrap(point2.y, point2.x, n4, d6, d9 = d6 + ((double)n4 - d5) * (d8 - d6) / (d7 - d5), d5, n4)) < (l3 = JCChartUtil.distTrap(point2.y, point2.x, n4, d9, d8, n4, d7)) ? l4 : l3) : JCChartUtil.distTrap(point2.y, point2.x, n4, d6, d8, d5, d7);
                        } else {
                            if (!bl4) {
                                d5 = this.dataObject.xaxis.toPixel(d4);
                                d6 = this.dataObject.yaxis.toPixel(d3);
                            }
                            d7 = this.dataObject.xaxis.toPixel(d2);
                            d8 = this.dataObject.yaxis.toPixel(d);
                            l = d8 < (double)n4 && d6 > (double)n4 || d6 < (double)n4 && d8 > (double)n4 ? ((l4 = JCChartUtil.distTrap(point2.x, point2.y, n4, d5, d9 = d5 + ((double)n4 - d6) * (d7 - d5) / (d8 - d6), d6, n4)) < (l3 = JCChartUtil.distTrap(point2.x, point2.y, n4, d9, d7, n4, d8)) ? l4 : l3) : JCChartUtil.distTrap(point2.x, point2.y, n4, d5, d7, d6, d8);
                        }
                        if (l < l2) {
                            n5 = n13 - 1;
                            n6 = n12;
                            l2 = l;
                        }
                        bl4 = true;
                        d5 = d7;
                        d6 = d8;
                    } else {
                        bl4 = false;
                    }
                    d4 = d2;
                    d3 = d;
                    bl2 = bl3;
                    n10 = n11;
                    ++n13;
                }
            }
            --n12;
        }
        if (n6 == -1 && (n6 = n7) < 0) {
            return null;
        }
        int n14 = n6;
        n8 = n5;
        Point point4 = this.dataObject.getFirstLast();
        if (n8 < point4.x) {
            n8 = point4.x;
            n9 = point4.x + 1;
        } else if (n8 > point4.y) {
            n8 = point4.y - 1;
            n9 = point4.y;
        } else {
            n9 = n8 + 1;
            if (n9 > point4.y) {
                n9 = --n8 + 1;
            }
        }
        if (n8 < point4.x) {
            n8 = n9 = point4.x;
        }
        d4 = chartDataViewSeriesArray[n14].getX(n8);
        d3 = chartDataViewSeriesArray[n14].getY(n8);
        d2 = chartDataViewSeriesArray[n14].getX(n9);
        d = chartDataViewSeriesArray[n14].getY(n9);
        n10 = d4 == this.dataObject.holeValue || d3 == this.dataObject.holeValue ? 1 : JCChartUtil.locateXY(d4, d3, minMax.min, minMax.max, minMax2.min, minMax2.max);
        int n15 = n11 = d2 == this.dataObject.holeValue || d == this.dataObject.holeValue ? 1 : JCChartUtil.locateXY(d2, d, minMax.min, minMax.max, minMax2.min, minMax2.max);
        if (bl) {
            if (n10 == 0) {
                d6 = this.dataObject.xaxis.toPixel(d4);
                d5 = this.dataObject.yaxis.toPixel(d3);
            }
            if (n11 == 0) {
                d8 = this.dataObject.xaxis.toPixel(d2);
                d7 = this.dataObject.yaxis.toPixel(d);
            }
        } else {
            if (n10 == 0) {
                d5 = this.dataObject.xaxis.toPixel(d4);
                d6 = this.dataObject.yaxis.toPixel(d3);
            }
            if (n11 == 0) {
                d7 = this.dataObject.xaxis.toPixel(d2);
                d8 = this.dataObject.yaxis.toPixel(d);
            }
        }
        if (n10 == 0 || n11 == 0) {
            if (n10 == 0 && n11 == 0) {
                switch (n) {
                    case 1: {
                        n3 = Math.abs((double)point2.x - d5) < Math.abs((double)point2.x - d7) ? n8 : n9;
                        break;
                    }
                    case 2: {
                        n3 = Math.abs((double)point2.y - d6) < Math.abs((double)point2.y - d8) ? n8 : n9;
                        break;
                    }
                    default: {
                        long l5 = (long)(((double)point2.x - d5) * ((double)point2.x - d5) + ((double)point2.y - d6) * ((double)point2.y - d6));
                        long l6 = (long)(((double)point2.x - d7) * ((double)point2.x - d7) + ((double)point2.y - d8) * ((double)point2.y - d8));
                        n3 = l5 < l6 ? n8 : n9;
                        break;
                    }
                }
            } else {
                n3 = n10 != 0 ? n9 : n8;
            }
            if ((n2 = n6) >= 0 && n3 >= 0) {
                jCDataIndex = new JCDataIndex(n3, chartDataViewSeriesArray[n2], n2);
                jCDataIndex.distance = (int)l2;
            }
        }
        return jCDataIndex;
    }

    Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = this.dataObject.getSeries(n2);
        boolean bl = this.dataObject.xaxis.isVertical;
        double d = chartDataViewSeries.getY(n);
        double d2 = chartDataViewSeries.getX(n);
        int n3 = -1;
        int n4 = -1;
        if (d2 != this.dataObject.holeValue && d != this.dataObject.holeValue) {
            if (bl) {
                n3 = this.dataObject.yaxis.toPixel(d);
                n4 = this.dataObject.xaxis.toPixel(d2);
            } else {
                n3 = this.dataObject.xaxis.toPixel(d2);
                n4 = this.dataObject.yaxis.toPixel(d);
            }
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        double d;
        double d2;
        double d3;
        double d4;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        ChartDataViewSeries chartDataViewSeries = jCDataIndex.series;
        boolean bl = jCDataIndex.dataView.xaxis.isVertical;
        this.r = this.chartArea.getDrawingArea();
        this.last = null;
        this.next = null;
        this.prev = null;
        if (jCDataIndex.point - 1 >= 0) {
            d4 = chartDataViewSeries.getX(jCDataIndex.point - 1);
            d3 = chartDataViewSeries.getY(jCDataIndex.point - 1);
            if (d4 == jCDataIndex.dataView.holeValue || d3 == jCDataIndex.dataView.holeValue) {
                d3 = jCDataIndex.dataView.yaxis.origin.value;
                d4 = chartDataViewSeries.getX(jCDataIndex.point);
            }
        } else {
            d4 = chartDataViewSeries.getX(jCDataIndex.point);
            d3 = jCDataIndex.dataView.yaxis.origin.value;
        }
        this.prev = bl ? new Point(jCDataIndex.dataView.yaxis.toPixel(d3) + this.r.x, jCDataIndex.dataView.xaxis.toPixel(d4) + this.r.y) : new Point(jCDataIndex.dataView.xaxis.toPixel(d4) + this.r.x, jCDataIndex.dataView.yaxis.toPixel(d3) + this.r.y);
        if (jCDataIndex.point + 1 < chartDataViewSeries.maxXIndex()) {
            d2 = chartDataViewSeries.getX(jCDataIndex.point + 1);
            d = chartDataViewSeries.getY(jCDataIndex.point + 1);
            if (d2 == jCDataIndex.dataView.holeValue || d == jCDataIndex.dataView.holeValue) {
                d = jCDataIndex.dataView.yaxis.origin.value;
                d2 = chartDataViewSeries.getX(jCDataIndex.point);
            }
        } else {
            d2 = chartDataViewSeries.getX(jCDataIndex.point);
            d = jCDataIndex.dataView.yaxis.origin.value;
        }
        if (bl) {
            this.next = new Point(jCDataIndex.dataView.yaxis.toPixel(d) + this.r.x, jCDataIndex.dataView.xaxis.toPixel(d2) + this.r.y);
            return;
        }
        this.next = new Point(jCDataIndex.dataView.xaxis.toPixel(d2) + this.r.x, jCDataIndex.dataView.yaxis.toPixel(d) + this.r.y);
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        if (this.last == null) {
            this.last = jCDataIndex.dataView.xaxis.isVertical ? new Point(n, jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point)) + this.r.y) : new Point(jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point)) + this.r.x, n2);
        } else if (jCDataIndex.dataView.xaxis.isVertical) {
            this.last.x = n;
        } else {
            this.last.y = n2;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        if (jCDataIndex.dataView.xaxis.isVertical) {
            return n - this.r.x;
        }
        return n2 - this.r.y;
    }
}

